package easik.ui.menu;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JFrame;

import easik.Easik;
import easik.sketch.Sketch;


/** 
 * Menu action for launching help
 * 
 * @author Rob Fletcher 2005
 * @author Vera Ranieri 2006
 * @version 2006-07-19 Vera Ranieri
 */
public class HelpAction extends AbstractAction {
	/**
	 * The current sketch
	 */
	Sketch _theSketch;
	/**
	 * The application frame
	 */
	JFrame _appFrame;
	/**
	 * Constructor
	 * @param inSketch The current sketch
	 * @param inFrame The current frame
	 */
	public HelpAction( Sketch inSketch, JFrame inFrame ) {
		super("Easik Help");		
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Review the documentation");
		_theSketch = inSketch;
		_appFrame = inFrame;
	}
	/**
	 * Registers when the user selects to view the Help 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		Easik.getInstance().getHelp().showHelpIndex();
	}
}
